<?php
/**
 * ParticipationProperties
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * ParticipationProperties Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ParticipationProperties implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ParticipationProperties';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'occurred_at' => 'int',
        'attendance_percentage' => 'string',
        'attendance_state' => 'string',
        'attendance_duration_seconds' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'occurred_at' => 'int64',
        'attendance_percentage' => null,
        'attendance_state' => null,
        'attendance_duration_seconds' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'occurred_at' => false,
        'attendance_percentage' => false,
        'attendance_state' => false,
        'attendance_duration_seconds' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'occurred_at' => 'occurredAt',
        'attendance_percentage' => 'attendancePercentage',
        'attendance_state' => 'attendanceState',
        'attendance_duration_seconds' => 'attendanceDurationSeconds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'occurred_at' => 'setOccurredAt',
        'attendance_percentage' => 'setAttendancePercentage',
        'attendance_state' => 'setAttendanceState',
        'attendance_duration_seconds' => 'setAttendanceDurationSeconds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'occurred_at' => 'getOccurredAt',
        'attendance_percentage' => 'getAttendancePercentage',
        'attendance_state' => 'getAttendanceState',
        'attendance_duration_seconds' => 'getAttendanceDurationSeconds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ATTENDANCE_STATE_REGISTERED = 'REGISTERED';
    public const ATTENDANCE_STATE_ATTENDED = 'ATTENDED';
    public const ATTENDANCE_STATE_CANCELLED = 'CANCELLED';
    public const ATTENDANCE_STATE__EMPTY = 'EMPTY';
    public const ATTENDANCE_STATE_NO_SHOW = 'NO_SHOW';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAttendanceStateAllowableValues()
    {
        return [
            self::ATTENDANCE_STATE_REGISTERED,
            self::ATTENDANCE_STATE_ATTENDED,
            self::ATTENDANCE_STATE_CANCELLED,
            self::ATTENDANCE_STATE__EMPTY,
            self::ATTENDANCE_STATE_NO_SHOW,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('occurred_at', $data ?? [], null);
        $this->setIfExists('attendance_percentage', $data ?? [], null);
        $this->setIfExists('attendance_state', $data ?? [], null);
        $this->setIfExists('attendance_duration_seconds', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['occurred_at'] === null) {
            $invalidProperties[] = "'occurred_at' can't be null";
        }
        if ($this->container['attendance_state'] === null) {
            $invalidProperties[] = "'attendance_state' can't be null";
        }
        $allowedValues = $this->getAttendanceStateAllowableValues();
        if (!is_null($this->container['attendance_state']) && !in_array($this->container['attendance_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'attendance_state', must be one of '%s'",
                $this->container['attendance_state'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets occurred_at
     *
     * @return int
     */
    public function getOccurredAt()
    {
        return $this->container['occurred_at'];
    }

    /**
     * Sets occurred_at
     *
     * @param int $occurred_at occurred_at
     *
     * @return self
     */
    public function setOccurredAt($occurred_at)
    {
        if (is_null($occurred_at)) {
            throw new \InvalidArgumentException('non-nullable occurred_at cannot be null');
        }
        $this->container['occurred_at'] = $occurred_at;

        return $this;
    }

    /**
     * Gets attendance_percentage
     *
     * @return string|null
     */
    public function getAttendancePercentage()
    {
        return $this->container['attendance_percentage'];
    }

    /**
     * Sets attendance_percentage
     *
     * @param string|null $attendance_percentage attendance_percentage
     *
     * @return self
     */
    public function setAttendancePercentage($attendance_percentage)
    {
        if (is_null($attendance_percentage)) {
            throw new \InvalidArgumentException('non-nullable attendance_percentage cannot be null');
        }
        $this->container['attendance_percentage'] = $attendance_percentage;

        return $this;
    }

    /**
     * Gets attendance_state
     *
     * @return string
     */
    public function getAttendanceState()
    {
        return $this->container['attendance_state'];
    }

    /**
     * Sets attendance_state
     *
     * @param string $attendance_state attendance_state
     *
     * @return self
     */
    public function setAttendanceState($attendance_state)
    {
        if (is_null($attendance_state)) {
            throw new \InvalidArgumentException('non-nullable attendance_state cannot be null');
        }
        $allowedValues = $this->getAttendanceStateAllowableValues();
        if (!in_array($attendance_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'attendance_state', must be one of '%s'",
                    $attendance_state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['attendance_state'] = $attendance_state;

        return $this;
    }

    /**
     * Gets attendance_duration_seconds
     *
     * @return int|null
     */
    public function getAttendanceDurationSeconds()
    {
        return $this->container['attendance_duration_seconds'];
    }

    /**
     * Sets attendance_duration_seconds
     *
     * @param int|null $attendance_duration_seconds attendance_duration_seconds
     *
     * @return self
     */
    public function setAttendanceDurationSeconds($attendance_duration_seconds)
    {
        if (is_null($attendance_duration_seconds)) {
            throw new \InvalidArgumentException('non-nullable attendance_duration_seconds cannot be null');
        }
        $this->container['attendance_duration_seconds'] = $attendance_duration_seconds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


