<?php
/**
 * PublicIndexOffset
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Lists
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lists
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Lists\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Lists\ObjectSerializer;

/**
 * PublicIndexOffset Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Lists
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicIndexOffset implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicIndexOffset';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'milliseconds' => 'int',
        'hours' => 'int',
        'seconds' => 'int',
        'months' => 'int',
        'weeks' => 'int',
        'minutes' => 'int',
        'quarters' => 'int',
        'days' => 'int',
        'years' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'milliseconds' => 'int32',
        'hours' => 'int32',
        'seconds' => 'int32',
        'months' => 'int32',
        'weeks' => 'int32',
        'minutes' => 'int32',
        'quarters' => 'int32',
        'days' => 'int32',
        'years' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'milliseconds' => false,
        'hours' => false,
        'seconds' => false,
        'months' => false,
        'weeks' => false,
        'minutes' => false,
        'quarters' => false,
        'days' => false,
        'years' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'milliseconds' => 'milliseconds',
        'hours' => 'hours',
        'seconds' => 'seconds',
        'months' => 'months',
        'weeks' => 'weeks',
        'minutes' => 'minutes',
        'quarters' => 'quarters',
        'days' => 'days',
        'years' => 'years'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'milliseconds' => 'setMilliseconds',
        'hours' => 'setHours',
        'seconds' => 'setSeconds',
        'months' => 'setMonths',
        'weeks' => 'setWeeks',
        'minutes' => 'setMinutes',
        'quarters' => 'setQuarters',
        'days' => 'setDays',
        'years' => 'setYears'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'milliseconds' => 'getMilliseconds',
        'hours' => 'getHours',
        'seconds' => 'getSeconds',
        'months' => 'getMonths',
        'weeks' => 'getWeeks',
        'minutes' => 'getMinutes',
        'quarters' => 'getQuarters',
        'days' => 'getDays',
        'years' => 'getYears'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('milliseconds', $data ?? [], null);
        $this->setIfExists('hours', $data ?? [], null);
        $this->setIfExists('seconds', $data ?? [], null);
        $this->setIfExists('months', $data ?? [], null);
        $this->setIfExists('weeks', $data ?? [], null);
        $this->setIfExists('minutes', $data ?? [], null);
        $this->setIfExists('quarters', $data ?? [], null);
        $this->setIfExists('days', $data ?? [], null);
        $this->setIfExists('years', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets milliseconds
     *
     * @return int|null
     */
    public function getMilliseconds()
    {
        return $this->container['milliseconds'];
    }

    /**
     * Sets milliseconds
     *
     * @param int|null $milliseconds milliseconds
     *
     * @return self
     */
    public function setMilliseconds($milliseconds)
    {
        if (is_null($milliseconds)) {
            throw new \InvalidArgumentException('non-nullable milliseconds cannot be null');
        }
        $this->container['milliseconds'] = $milliseconds;

        return $this;
    }

    /**
     * Gets hours
     *
     * @return int|null
     */
    public function getHours()
    {
        return $this->container['hours'];
    }

    /**
     * Sets hours
     *
     * @param int|null $hours hours
     *
     * @return self
     */
    public function setHours($hours)
    {
        if (is_null($hours)) {
            throw new \InvalidArgumentException('non-nullable hours cannot be null');
        }
        $this->container['hours'] = $hours;

        return $this;
    }

    /**
     * Gets seconds
     *
     * @return int|null
     */
    public function getSeconds()
    {
        return $this->container['seconds'];
    }

    /**
     * Sets seconds
     *
     * @param int|null $seconds seconds
     *
     * @return self
     */
    public function setSeconds($seconds)
    {
        if (is_null($seconds)) {
            throw new \InvalidArgumentException('non-nullable seconds cannot be null');
        }
        $this->container['seconds'] = $seconds;

        return $this;
    }

    /**
     * Gets months
     *
     * @return int|null
     */
    public function getMonths()
    {
        return $this->container['months'];
    }

    /**
     * Sets months
     *
     * @param int|null $months months
     *
     * @return self
     */
    public function setMonths($months)
    {
        if (is_null($months)) {
            throw new \InvalidArgumentException('non-nullable months cannot be null');
        }
        $this->container['months'] = $months;

        return $this;
    }

    /**
     * Gets weeks
     *
     * @return int|null
     */
    public function getWeeks()
    {
        return $this->container['weeks'];
    }

    /**
     * Sets weeks
     *
     * @param int|null $weeks weeks
     *
     * @return self
     */
    public function setWeeks($weeks)
    {
        if (is_null($weeks)) {
            throw new \InvalidArgumentException('non-nullable weeks cannot be null');
        }
        $this->container['weeks'] = $weeks;

        return $this;
    }

    /**
     * Gets minutes
     *
     * @return int|null
     */
    public function getMinutes()
    {
        return $this->container['minutes'];
    }

    /**
     * Sets minutes
     *
     * @param int|null $minutes minutes
     *
     * @return self
     */
    public function setMinutes($minutes)
    {
        if (is_null($minutes)) {
            throw new \InvalidArgumentException('non-nullable minutes cannot be null');
        }
        $this->container['minutes'] = $minutes;

        return $this;
    }

    /**
     * Gets quarters
     *
     * @return int|null
     */
    public function getQuarters()
    {
        return $this->container['quarters'];
    }

    /**
     * Sets quarters
     *
     * @param int|null $quarters quarters
     *
     * @return self
     */
    public function setQuarters($quarters)
    {
        if (is_null($quarters)) {
            throw new \InvalidArgumentException('non-nullable quarters cannot be null');
        }
        $this->container['quarters'] = $quarters;

        return $this;
    }

    /**
     * Gets days
     *
     * @return int|null
     */
    public function getDays()
    {
        return $this->container['days'];
    }

    /**
     * Sets days
     *
     * @param int|null $days days
     *
     * @return self
     */
    public function setDays($days)
    {
        if (is_null($days)) {
            throw new \InvalidArgumentException('non-nullable days cannot be null');
        }
        $this->container['days'] = $days;

        return $this;
    }

    /**
     * Gets years
     *
     * @return int|null
     */
    public function getYears()
    {
        return $this->container['years'];
    }

    /**
     * Sets years
     *
     * @param int|null $years years
     *
     * @return self
     */
    public function setYears($years)
    {
        if (is_null($years)) {
            throw new \InvalidArgumentException('non-nullable years cannot be null');
        }
        $this->container['years'] = $years;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


