<?php
/**
 * PublicImportError
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Imports
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Imports
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Imports\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Imports\ObjectSerializer;

/**
 * PublicImportError Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Imports
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicImportError implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicImportError';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'created_at' => 'int',
        'extra_context' => 'string',
        'object_type_id' => 'string',
        'error_type' => 'string',
        'known_column_number' => 'int',
        'id' => 'string',
        'source_data' => '\HubSpot\Client\Crm\Imports\Model\ImportRowCore',
        'object_type' => 'string',
        'invalid_value' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'created_at' => 'int32',
        'extra_context' => null,
        'object_type_id' => null,
        'error_type' => null,
        'known_column_number' => 'int32',
        'id' => null,
        'source_data' => null,
        'object_type' => null,
        'invalid_value' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'created_at' => false,
        'extra_context' => false,
        'object_type_id' => false,
        'error_type' => false,
        'known_column_number' => false,
        'id' => false,
        'source_data' => false,
        'object_type' => false,
        'invalid_value' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'created_at' => 'createdAt',
        'extra_context' => 'extraContext',
        'object_type_id' => 'objectTypeId',
        'error_type' => 'errorType',
        'known_column_number' => 'knownColumnNumber',
        'id' => 'id',
        'source_data' => 'sourceData',
        'object_type' => 'objectType',
        'invalid_value' => 'invalidValue'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'created_at' => 'setCreatedAt',
        'extra_context' => 'setExtraContext',
        'object_type_id' => 'setObjectTypeId',
        'error_type' => 'setErrorType',
        'known_column_number' => 'setKnownColumnNumber',
        'id' => 'setId',
        'source_data' => 'setSourceData',
        'object_type' => 'setObjectType',
        'invalid_value' => 'setInvalidValue'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'created_at' => 'getCreatedAt',
        'extra_context' => 'getExtraContext',
        'object_type_id' => 'getObjectTypeId',
        'error_type' => 'getErrorType',
        'known_column_number' => 'getKnownColumnNumber',
        'id' => 'getId',
        'source_data' => 'getSourceData',
        'object_type' => 'getObjectType',
        'invalid_value' => 'getInvalidValue'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ERROR_TYPE_INCORRECT_NUMBER_OF_COLUMNS = 'INCORRECT_NUMBER_OF_COLUMNS';
    public const ERROR_TYPE_INVALID_OBJECT_ID = 'INVALID_OBJECT_ID';
    public const ERROR_TYPE_INVALID_ASSOCIATION_IDENTIFIER = 'INVALID_ASSOCIATION_IDENTIFIER';
    public const ERROR_TYPE_NO_OBJECT_ID_FROM_ASSOCIATION_IDENTIFIER = 'NO_OBJECT_ID_FROM_ASSOCIATION_IDENTIFIER';
    public const ERROR_TYPE_MULTIPLE_COMPANIES_WITH_THIS_DOMAIN = 'MULTIPLE_COMPANIES_WITH_THIS_DOMAIN';
    public const ERROR_TYPE_PROPERTY_DEFINITION_NOT_FOUND = 'PROPERTY_DEFINITION_NOT_FOUND';
    public const ERROR_TYPE_PROPERTY_VALUE_NOT_FOUND = 'PROPERTY_VALUE_NOT_FOUND';
    public const ERROR_TYPE_COULD_NOT_FIND_OWNER = 'COULD_NOT_FIND_OWNER';
    public const ERROR_TYPE_MULTIPLE_OWNERS_FOUND = 'MULTIPLE_OWNERS_FOUND';
    public const ERROR_TYPE_COULD_NOT_FIND_BUSINESS_UNIT = 'COULD_NOT_FIND_BUSINESS_UNIT';
    public const ERROR_TYPE_COULD_NOT_PARSE_NUMBER = 'COULD_NOT_PARSE_NUMBER';
    public const ERROR_TYPE_COULD_NOT_PARSE_DATE = 'COULD_NOT_PARSE_DATE';
    public const ERROR_TYPE_COULD_NOT_PARSE_TERM = 'COULD_NOT_PARSE_TERM';
    public const ERROR_TYPE_OUTSIDE_VALID_TIME_RANGE = 'OUTSIDE_VALID_TIME_RANGE';
    public const ERROR_TYPE_OUTSIDE_VALID_TERM_RANGE = 'OUTSIDE_VALID_TERM_RANGE';
    public const ERROR_TYPE_COULD_NOT_PARSE_ROW = 'COULD_NOT_PARSE_ROW';
    public const ERROR_TYPE_INVALID_ENUMERATION_OPTION = 'INVALID_ENUMERATION_OPTION';
    public const ERROR_TYPE_AMBIGUOUS_ENUMERATION_OPTION = 'AMBIGUOUS_ENUMERATION_OPTION';
    public const ERROR_TYPE_FAILED_VALIDATION = 'FAILED_VALIDATION';
    public const ERROR_TYPE_FAILED_TO_CREATE_ASSOCIATION = 'FAILED_TO_CREATE_ASSOCIATION';
    public const ERROR_TYPE_FILE_NOT_FOUND = 'FILE_NOT_FOUND';
    public const ERROR_TYPE_INVALID_COLUMN_CONFIGURATION = 'INVALID_COLUMN_CONFIGURATION';
    public const ERROR_TYPE_INVALID_FILE_TYPE = 'INVALID_FILE_TYPE';
    public const ERROR_TYPE_INVALID_SPREADSHEET = 'INVALID_SPREADSHEET';
    public const ERROR_TYPE_INVALID_SHEET_COUNT = 'INVALID_SHEET_COUNT';
    public const ERROR_TYPE_FAILED_TO_PROCESS_OBJECT_WITH_EMPTY_PROPERTY_VALUES = 'FAILED_TO_PROCESS_OBJECT_WITH_EMPTY_PROPERTY_VALUES';
    public const ERROR_TYPE_UNKNOWN_BAD_REQUEST = 'UNKNOWN_BAD_REQUEST';
    public const ERROR_TYPE_GDPR_BLACKLISTED_EMAIL = 'GDPR_BLACKLISTED_EMAIL';
    public const ERROR_TYPE_DUPLICATE_ASSOCIATION_ID = 'DUPLICATE_ASSOCIATION_ID';
    public const ERROR_TYPE_LIMIT_EXCEEDED = 'LIMIT_EXCEEDED';
    public const ERROR_TYPE_PORTAL_WIDE_CUSTOM_OBJECT_LIMIT_EXCEEDED = 'PORTAL_WIDE_CUSTOM_OBJECT_LIMIT_EXCEEDED';
    public const ERROR_TYPE_INVALID_ALTERNATE_ID = 'INVALID_ALTERNATE_ID';
    public const ERROR_TYPE_INVALID_EMAIL = 'INVALID_EMAIL';
    public const ERROR_TYPE_INVALID_DOMAIN = 'INVALID_DOMAIN';
    public const ERROR_TYPE_DUPLICATE_ROW_CONTENT = 'DUPLICATE_ROW_CONTENT';
    public const ERROR_TYPE_INVALID_NUMBER_SIZE = 'INVALID_NUMBER_SIZE';
    public const ERROR_TYPE_UNKNOWN_ERROR = 'UNKNOWN_ERROR';
    public const ERROR_TYPE_FAILED_TO_OPT_OUT_CONTACT = 'FAILED_TO_OPT_OUT_CONTACT';
    public const ERROR_TYPE_INVALID_REQUIRED_PROPERTY = 'INVALID_REQUIRED_PROPERTY';
    public const ERROR_TYPE_MISSING_REQUIRED_PROPERTY = 'MISSING_REQUIRED_PROPERTY';
    public const ERROR_TYPE_DUPLICATE_ALTERNATE_ID = 'DUPLICATE_ALTERNATE_ID';
    public const ERROR_TYPE_DUPLICATE_OBJECT_ID = 'DUPLICATE_OBJECT_ID';
    public const ERROR_TYPE_DUPLICATE_UNIQUE_PROPERTY_VALUE = 'DUPLICATE_UNIQUE_PROPERTY_VALUE';
    public const ERROR_TYPE_BLANK_VALUE_PROVIDED = 'BLANK_VALUE_PROVIDED';
    public const ERROR_TYPE_UNKNOWN_ASSOCIATION_RECORD_ID = 'UNKNOWN_ASSOCIATION_RECORD_ID';
    public const ERROR_TYPE_INVALID_RECORD_ID = 'INVALID_RECORD_ID';
    public const ERROR_TYPE_DUPLICATE_RECORD_ID = 'DUPLICATE_RECORD_ID';
    public const ERROR_TYPE_INVALID_CUSTOM_PROPERTY_VALIDATION = 'INVALID_CUSTOM_PROPERTY_VALIDATION';
    public const ERROR_TYPE_CREATE_ONLY_IMPORT = 'CREATE_ONLY_IMPORT';
    public const ERROR_TYPE_UPDATE_ONLY_IMPORT = 'UPDATE_ONLY_IMPORT';
    public const ERROR_TYPE_COLUMN_TOO_LARGE = 'COLUMN_TOO_LARGE';
    public const ERROR_TYPE_ROW_DATA_TOO_LARGE = 'ROW_DATA_TOO_LARGE';
    public const ERROR_TYPE_INVALID_EVENT_TIMESTAMP = 'INVALID_EVENT_TIMESTAMP';
    public const ERROR_TYPE_INVALID_EVENT = 'INVALID_EVENT';
    public const ERROR_TYPE_DUPLICATE_EVENT = 'DUPLICATE_EVENT';
    public const ERROR_TYPE_MISSING_EVENT_DEFINITION = 'MISSING_EVENT_DEFINITION';
    public const OBJECT_TYPE_CONTACT = 'CONTACT';
    public const OBJECT_TYPE_COMPANY = 'COMPANY';
    public const OBJECT_TYPE_DEAL = 'DEAL';
    public const OBJECT_TYPE_ENGAGEMENT = 'ENGAGEMENT';
    public const OBJECT_TYPE_TICKET = 'TICKET';
    public const OBJECT_TYPE_OWNER = 'OWNER';
    public const OBJECT_TYPE_PRODUCT = 'PRODUCT';
    public const OBJECT_TYPE_LINE_ITEM = 'LINE_ITEM';
    public const OBJECT_TYPE_BET_DELIVERABLE_SERVICE = 'BET_DELIVERABLE_SERVICE';
    public const OBJECT_TYPE_CONTENT = 'CONTENT';
    public const OBJECT_TYPE_CONVERSATION = 'CONVERSATION';
    public const OBJECT_TYPE_BET_ALERT = 'BET_ALERT';
    public const OBJECT_TYPE_PORTAL = 'PORTAL';
    public const OBJECT_TYPE_QUOTE = 'QUOTE';
    public const OBJECT_TYPE_FORM_SUBMISSION_INBOUNDDB = 'FORM_SUBMISSION_INBOUNDDB';
    public const OBJECT_TYPE_QUOTA = 'QUOTA';
    public const OBJECT_TYPE_UNSUBSCRIBE = 'UNSUBSCRIBE';
    public const OBJECT_TYPE_COMMUNICATION = 'COMMUNICATION';
    public const OBJECT_TYPE_FEEDBACK_SUBMISSION = 'FEEDBACK_SUBMISSION';
    public const OBJECT_TYPE_ATTRIBUTION = 'ATTRIBUTION';
    public const OBJECT_TYPE_SALESFORCE_SYNC_ERROR = 'SALESFORCE_SYNC_ERROR';
    public const OBJECT_TYPE_RESTORABLE_CRM_OBJECT = 'RESTORABLE_CRM_OBJECT';
    public const OBJECT_TYPE_HUB = 'HUB';
    public const OBJECT_TYPE_LANDING_PAGE = 'LANDING_PAGE';
    public const OBJECT_TYPE_PRODUCT_OR_FOLDER = 'PRODUCT_OR_FOLDER';
    public const OBJECT_TYPE_TASK = 'TASK';
    public const OBJECT_TYPE_FORM = 'FORM';
    public const OBJECT_TYPE_MARKETING_EMAIL = 'MARKETING_EMAIL';
    public const OBJECT_TYPE_AD_ACCOUNT = 'AD_ACCOUNT';
    public const OBJECT_TYPE_AD_CAMPAIGN = 'AD_CAMPAIGN';
    public const OBJECT_TYPE_AD_GROUP = 'AD_GROUP';
    public const OBJECT_TYPE_AD = 'AD';
    public const OBJECT_TYPE_KEYWORD = 'KEYWORD';
    public const OBJECT_TYPE_CAMPAIGN = 'CAMPAIGN';
    public const OBJECT_TYPE_SOCIAL_CHANNEL = 'SOCIAL_CHANNEL';
    public const OBJECT_TYPE_SOCIAL_POST = 'SOCIAL_POST';
    public const OBJECT_TYPE_SITE_PAGE = 'SITE_PAGE';
    public const OBJECT_TYPE_BLOG_POST = 'BLOG_POST';
    public const OBJECT_TYPE_IMPORT = 'IMPORT';
    public const OBJECT_TYPE_EXPORT = 'EXPORT';
    public const OBJECT_TYPE_CTA = 'CTA';
    public const OBJECT_TYPE_TASK_TEMPLATE = 'TASK_TEMPLATE';
    public const OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW = 'AUTOMATION_PLATFORM_FLOW';
    public const OBJECT_TYPE_OBJECT_LIST = 'OBJECT_LIST';
    public const OBJECT_TYPE_NOTE = 'NOTE';
    public const OBJECT_TYPE_MEETING_EVENT = 'MEETING_EVENT';
    public const OBJECT_TYPE_CALL = 'CALL';
    public const OBJECT_TYPE_EMAIL = 'EMAIL';
    public const OBJECT_TYPE_PUBLISHING_TASK = 'PUBLISHING_TASK';
    public const OBJECT_TYPE_CONVERSATION_SESSION = 'CONVERSATION_SESSION';
    public const OBJECT_TYPE_CONTACT_CREATE_ATTRIBUTION = 'CONTACT_CREATE_ATTRIBUTION';
    public const OBJECT_TYPE_INVOICE = 'INVOICE';
    public const OBJECT_TYPE_MARKETING_EVENT = 'MARKETING_EVENT';
    public const OBJECT_TYPE_CONVERSATION_INBOX = 'CONVERSATION_INBOX';
    public const OBJECT_TYPE_CHATFLOW = 'CHATFLOW';
    public const OBJECT_TYPE_MEDIA_BRIDGE = 'MEDIA_BRIDGE';
    public const OBJECT_TYPE_SEQUENCE = 'SEQUENCE';
    public const OBJECT_TYPE_SEQUENCE_STEP = 'SEQUENCE_STEP';
    public const OBJECT_TYPE_FORECAST = 'FORECAST';
    public const OBJECT_TYPE_SNIPPET = 'SNIPPET';
    public const OBJECT_TYPE_TEMPLATE = 'TEMPLATE';
    public const OBJECT_TYPE_DEAL_CREATE_ATTRIBUTION = 'DEAL_CREATE_ATTRIBUTION';
    public const OBJECT_TYPE_QUOTE_TEMPLATE = 'QUOTE_TEMPLATE';
    public const OBJECT_TYPE_QUOTE_MODULE = 'QUOTE_MODULE';
    public const OBJECT_TYPE_QUOTE_MODULE_FIELD = 'QUOTE_MODULE_FIELD';
    public const OBJECT_TYPE_QUOTE_FIELD = 'QUOTE_FIELD';
    public const OBJECT_TYPE_SEQUENCE_ENROLLMENT = 'SEQUENCE_ENROLLMENT';
    public const OBJECT_TYPE_SUBSCRIPTION = 'SUBSCRIPTION';
    public const OBJECT_TYPE_ACCEPTANCE_TEST = 'ACCEPTANCE_TEST';
    public const OBJECT_TYPE_SOCIAL_BROADCAST = 'SOCIAL_BROADCAST';
    public const OBJECT_TYPE_DEAL_SPLIT = 'DEAL_SPLIT';
    public const OBJECT_TYPE_DEAL_REGISTRATION = 'DEAL_REGISTRATION';
    public const OBJECT_TYPE_GOAL_TARGET = 'GOAL_TARGET';
    public const OBJECT_TYPE_GOAL_TARGET_GROUP = 'GOAL_TARGET_GROUP';
    public const OBJECT_TYPE_PORTAL_OBJECT_SYNC_MESSAGE = 'PORTAL_OBJECT_SYNC_MESSAGE';
    public const OBJECT_TYPE_FILE_MANAGER_FILE = 'FILE_MANAGER_FILE';
    public const OBJECT_TYPE_FILE_MANAGER_FOLDER = 'FILE_MANAGER_FOLDER';
    public const OBJECT_TYPE_SEQUENCE_STEP_ENROLLMENT = 'SEQUENCE_STEP_ENROLLMENT';
    public const OBJECT_TYPE_APPROVAL = 'APPROVAL';
    public const OBJECT_TYPE_APPROVAL_STEP = 'APPROVAL_STEP';
    public const OBJECT_TYPE_CTA_VARIANT = 'CTA_VARIANT';
    public const OBJECT_TYPE_SALES_DOCUMENT = 'SALES_DOCUMENT';
    public const OBJECT_TYPE_DISCOUNT = 'DISCOUNT';
    public const OBJECT_TYPE_FEE = 'FEE';
    public const OBJECT_TYPE_TAX = 'TAX';
    public const OBJECT_TYPE_MARKETING_CALENDAR = 'MARKETING_CALENDAR';
    public const OBJECT_TYPE_PERMISSIONS_TESTING = 'PERMISSIONS_TESTING';
    public const OBJECT_TYPE_PRIVACY_SCANNER_COOKIE = 'PRIVACY_SCANNER_COOKIE';
    public const OBJECT_TYPE_DATA_SYNC_STATE = 'DATA_SYNC_STATE';
    public const OBJECT_TYPE_WEB_INTERACTIVE = 'WEB_INTERACTIVE';
    public const OBJECT_TYPE_PLAYBOOK = 'PLAYBOOK';
    public const OBJECT_TYPE_FOLDER = 'FOLDER';
    public const OBJECT_TYPE_PLAYBOOK_QUESTION = 'PLAYBOOK_QUESTION';
    public const OBJECT_TYPE_PLAYBOOK_SUBMISSION = 'PLAYBOOK_SUBMISSION';
    public const OBJECT_TYPE_PLAYBOOK_SUBMISSION_ANSWER = 'PLAYBOOK_SUBMISSION_ANSWER';
    public const OBJECT_TYPE_COMMERCE_PAYMENT = 'COMMERCE_PAYMENT';
    public const OBJECT_TYPE_GSC_PROPERTY = 'GSC_PROPERTY';
    public const OBJECT_TYPE_SOX_PROTECTED_DUMMY_TYPE = 'SOX_PROTECTED_DUMMY_TYPE';
    public const OBJECT_TYPE_BLOG_LISTING_PAGE = 'BLOG_LISTING_PAGE';
    public const OBJECT_TYPE_QUARANTINED_SUBMISSION = 'QUARANTINED_SUBMISSION';
    public const OBJECT_TYPE_PAYMENT_SCHEDULE = 'PAYMENT_SCHEDULE';
    public const OBJECT_TYPE_PAYMENT_SCHEDULE_INSTALLMENT = 'PAYMENT_SCHEDULE_INSTALLMENT';
    public const OBJECT_TYPE_MARKETING_CAMPAIGN_UTM = 'MARKETING_CAMPAIGN_UTM';
    public const OBJECT_TYPE_DISCOUNT_TEMPLATE = 'DISCOUNT_TEMPLATE';
    public const OBJECT_TYPE_DISCOUNT_CODE = 'DISCOUNT_CODE';
    public const OBJECT_TYPE_FEEDBACK_SURVEY = 'FEEDBACK_SURVEY';
    public const OBJECT_TYPE_CMS_URL = 'CMS_URL';
    public const OBJECT_TYPE_SALES_TASK = 'SALES_TASK';
    public const OBJECT_TYPE_SALES_WORKLOAD = 'SALES_WORKLOAD';
    public const OBJECT_TYPE_USER = 'USER';
    public const OBJECT_TYPE_POSTAL_MAIL = 'POSTAL_MAIL';
    public const OBJECT_TYPE_SCHEMAS_BACKEND_TEST = 'SCHEMAS_BACKEND_TEST';
    public const OBJECT_TYPE_PAYMENT_LINK = 'PAYMENT_LINK';
    public const OBJECT_TYPE_SUBMISSION_TAG = 'SUBMISSION_TAG';
    public const OBJECT_TYPE_CAMPAIGN_STEP = 'CAMPAIGN_STEP';
    public const OBJECT_TYPE_SCHEDULING_PAGE = 'SCHEDULING_PAGE';
    public const OBJECT_TYPE_SOX_PROTECTED_TEST_TYPE = 'SOX_PROTECTED_TEST_TYPE';
    public const OBJECT_TYPE_ORDER = 'ORDER';
    public const OBJECT_TYPE_MARKETING_SMS = 'MARKETING_SMS';
    public const OBJECT_TYPE_PARTNER_ACCOUNT = 'PARTNER_ACCOUNT';
    public const OBJECT_TYPE_CAMPAIGN_TEMPLATE = 'CAMPAIGN_TEMPLATE';
    public const OBJECT_TYPE_CAMPAIGN_TEMPLATE_STEP = 'CAMPAIGN_TEMPLATE_STEP';
    public const OBJECT_TYPE_PLAYLIST = 'PLAYLIST';
    public const OBJECT_TYPE_CLIP = 'CLIP';
    public const OBJECT_TYPE_CAMPAIGN_BUDGET_ITEM = 'CAMPAIGN_BUDGET_ITEM';
    public const OBJECT_TYPE_CAMPAIGN_SPEND_ITEM = 'CAMPAIGN_SPEND_ITEM';
    public const OBJECT_TYPE_MIC = 'MIC';
    public const OBJECT_TYPE_CONTENT_AUDIT = 'CONTENT_AUDIT';
    public const OBJECT_TYPE_CONTENT_AUDIT_PAGE = 'CONTENT_AUDIT_PAGE';
    public const OBJECT_TYPE_PLAYLIST_FOLDER = 'PLAYLIST_FOLDER';
    public const OBJECT_TYPE_LEAD = 'LEAD';
    public const OBJECT_TYPE_ABANDONED_CART = 'ABANDONED_CART';
    public const OBJECT_TYPE_EXTERNAL_WEB_URL = 'EXTERNAL_WEB_URL';
    public const OBJECT_TYPE_VIEW = 'VIEW';
    public const OBJECT_TYPE_VIEW_BLOCK = 'VIEW_BLOCK';
    public const OBJECT_TYPE_ROSTER = 'ROSTER';
    public const OBJECT_TYPE_CART = 'CART';
    public const OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW_ACTION = 'AUTOMATION_PLATFORM_FLOW_ACTION';
    public const OBJECT_TYPE_SOCIAL_PROFILE = 'SOCIAL_PROFILE';
    public const OBJECT_TYPE_PARTNER_CLIENT = 'PARTNER_CLIENT';
    public const OBJECT_TYPE_ROSTER_MEMBER = 'ROSTER_MEMBER';
    public const OBJECT_TYPE_MARKETING_EVENT_ATTENDANCE = 'MARKETING_EVENT_ATTENDANCE';
    public const OBJECT_TYPE_ALL_PAGES = 'ALL_PAGES';
    public const OBJECT_TYPE_AI_FORECAST = 'AI_FORECAST';
    public const OBJECT_TYPE_CRM_PIPELINES_DUMMY_TYPE = 'CRM_PIPELINES_DUMMY_TYPE';
    public const OBJECT_TYPE_UNKNOWN = 'UNKNOWN';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getErrorTypeAllowableValues()
    {
        return [
            self::ERROR_TYPE_INCORRECT_NUMBER_OF_COLUMNS,
            self::ERROR_TYPE_INVALID_OBJECT_ID,
            self::ERROR_TYPE_INVALID_ASSOCIATION_IDENTIFIER,
            self::ERROR_TYPE_NO_OBJECT_ID_FROM_ASSOCIATION_IDENTIFIER,
            self::ERROR_TYPE_MULTIPLE_COMPANIES_WITH_THIS_DOMAIN,
            self::ERROR_TYPE_PROPERTY_DEFINITION_NOT_FOUND,
            self::ERROR_TYPE_PROPERTY_VALUE_NOT_FOUND,
            self::ERROR_TYPE_COULD_NOT_FIND_OWNER,
            self::ERROR_TYPE_MULTIPLE_OWNERS_FOUND,
            self::ERROR_TYPE_COULD_NOT_FIND_BUSINESS_UNIT,
            self::ERROR_TYPE_COULD_NOT_PARSE_NUMBER,
            self::ERROR_TYPE_COULD_NOT_PARSE_DATE,
            self::ERROR_TYPE_COULD_NOT_PARSE_TERM,
            self::ERROR_TYPE_OUTSIDE_VALID_TIME_RANGE,
            self::ERROR_TYPE_OUTSIDE_VALID_TERM_RANGE,
            self::ERROR_TYPE_COULD_NOT_PARSE_ROW,
            self::ERROR_TYPE_INVALID_ENUMERATION_OPTION,
            self::ERROR_TYPE_AMBIGUOUS_ENUMERATION_OPTION,
            self::ERROR_TYPE_FAILED_VALIDATION,
            self::ERROR_TYPE_FAILED_TO_CREATE_ASSOCIATION,
            self::ERROR_TYPE_FILE_NOT_FOUND,
            self::ERROR_TYPE_INVALID_COLUMN_CONFIGURATION,
            self::ERROR_TYPE_INVALID_FILE_TYPE,
            self::ERROR_TYPE_INVALID_SPREADSHEET,
            self::ERROR_TYPE_INVALID_SHEET_COUNT,
            self::ERROR_TYPE_FAILED_TO_PROCESS_OBJECT_WITH_EMPTY_PROPERTY_VALUES,
            self::ERROR_TYPE_UNKNOWN_BAD_REQUEST,
            self::ERROR_TYPE_GDPR_BLACKLISTED_EMAIL,
            self::ERROR_TYPE_DUPLICATE_ASSOCIATION_ID,
            self::ERROR_TYPE_LIMIT_EXCEEDED,
            self::ERROR_TYPE_PORTAL_WIDE_CUSTOM_OBJECT_LIMIT_EXCEEDED,
            self::ERROR_TYPE_INVALID_ALTERNATE_ID,
            self::ERROR_TYPE_INVALID_EMAIL,
            self::ERROR_TYPE_INVALID_DOMAIN,
            self::ERROR_TYPE_DUPLICATE_ROW_CONTENT,
            self::ERROR_TYPE_INVALID_NUMBER_SIZE,
            self::ERROR_TYPE_UNKNOWN_ERROR,
            self::ERROR_TYPE_FAILED_TO_OPT_OUT_CONTACT,
            self::ERROR_TYPE_INVALID_REQUIRED_PROPERTY,
            self::ERROR_TYPE_MISSING_REQUIRED_PROPERTY,
            self::ERROR_TYPE_DUPLICATE_ALTERNATE_ID,
            self::ERROR_TYPE_DUPLICATE_OBJECT_ID,
            self::ERROR_TYPE_DUPLICATE_UNIQUE_PROPERTY_VALUE,
            self::ERROR_TYPE_BLANK_VALUE_PROVIDED,
            self::ERROR_TYPE_UNKNOWN_ASSOCIATION_RECORD_ID,
            self::ERROR_TYPE_INVALID_RECORD_ID,
            self::ERROR_TYPE_DUPLICATE_RECORD_ID,
            self::ERROR_TYPE_INVALID_CUSTOM_PROPERTY_VALIDATION,
            self::ERROR_TYPE_CREATE_ONLY_IMPORT,
            self::ERROR_TYPE_UPDATE_ONLY_IMPORT,
            self::ERROR_TYPE_COLUMN_TOO_LARGE,
            self::ERROR_TYPE_ROW_DATA_TOO_LARGE,
            self::ERROR_TYPE_INVALID_EVENT_TIMESTAMP,
            self::ERROR_TYPE_INVALID_EVENT,
            self::ERROR_TYPE_DUPLICATE_EVENT,
            self::ERROR_TYPE_MISSING_EVENT_DEFINITION,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getObjectTypeAllowableValues()
    {
        return [
            self::OBJECT_TYPE_CONTACT,
            self::OBJECT_TYPE_COMPANY,
            self::OBJECT_TYPE_DEAL,
            self::OBJECT_TYPE_ENGAGEMENT,
            self::OBJECT_TYPE_TICKET,
            self::OBJECT_TYPE_OWNER,
            self::OBJECT_TYPE_PRODUCT,
            self::OBJECT_TYPE_LINE_ITEM,
            self::OBJECT_TYPE_BET_DELIVERABLE_SERVICE,
            self::OBJECT_TYPE_CONTENT,
            self::OBJECT_TYPE_CONVERSATION,
            self::OBJECT_TYPE_BET_ALERT,
            self::OBJECT_TYPE_PORTAL,
            self::OBJECT_TYPE_QUOTE,
            self::OBJECT_TYPE_FORM_SUBMISSION_INBOUNDDB,
            self::OBJECT_TYPE_QUOTA,
            self::OBJECT_TYPE_UNSUBSCRIBE,
            self::OBJECT_TYPE_COMMUNICATION,
            self::OBJECT_TYPE_FEEDBACK_SUBMISSION,
            self::OBJECT_TYPE_ATTRIBUTION,
            self::OBJECT_TYPE_SALESFORCE_SYNC_ERROR,
            self::OBJECT_TYPE_RESTORABLE_CRM_OBJECT,
            self::OBJECT_TYPE_HUB,
            self::OBJECT_TYPE_LANDING_PAGE,
            self::OBJECT_TYPE_PRODUCT_OR_FOLDER,
            self::OBJECT_TYPE_TASK,
            self::OBJECT_TYPE_FORM,
            self::OBJECT_TYPE_MARKETING_EMAIL,
            self::OBJECT_TYPE_AD_ACCOUNT,
            self::OBJECT_TYPE_AD_CAMPAIGN,
            self::OBJECT_TYPE_AD_GROUP,
            self::OBJECT_TYPE_AD,
            self::OBJECT_TYPE_KEYWORD,
            self::OBJECT_TYPE_CAMPAIGN,
            self::OBJECT_TYPE_SOCIAL_CHANNEL,
            self::OBJECT_TYPE_SOCIAL_POST,
            self::OBJECT_TYPE_SITE_PAGE,
            self::OBJECT_TYPE_BLOG_POST,
            self::OBJECT_TYPE_IMPORT,
            self::OBJECT_TYPE_EXPORT,
            self::OBJECT_TYPE_CTA,
            self::OBJECT_TYPE_TASK_TEMPLATE,
            self::OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW,
            self::OBJECT_TYPE_OBJECT_LIST,
            self::OBJECT_TYPE_NOTE,
            self::OBJECT_TYPE_MEETING_EVENT,
            self::OBJECT_TYPE_CALL,
            self::OBJECT_TYPE_EMAIL,
            self::OBJECT_TYPE_PUBLISHING_TASK,
            self::OBJECT_TYPE_CONVERSATION_SESSION,
            self::OBJECT_TYPE_CONTACT_CREATE_ATTRIBUTION,
            self::OBJECT_TYPE_INVOICE,
            self::OBJECT_TYPE_MARKETING_EVENT,
            self::OBJECT_TYPE_CONVERSATION_INBOX,
            self::OBJECT_TYPE_CHATFLOW,
            self::OBJECT_TYPE_MEDIA_BRIDGE,
            self::OBJECT_TYPE_SEQUENCE,
            self::OBJECT_TYPE_SEQUENCE_STEP,
            self::OBJECT_TYPE_FORECAST,
            self::OBJECT_TYPE_SNIPPET,
            self::OBJECT_TYPE_TEMPLATE,
            self::OBJECT_TYPE_DEAL_CREATE_ATTRIBUTION,
            self::OBJECT_TYPE_QUOTE_TEMPLATE,
            self::OBJECT_TYPE_QUOTE_MODULE,
            self::OBJECT_TYPE_QUOTE_MODULE_FIELD,
            self::OBJECT_TYPE_QUOTE_FIELD,
            self::OBJECT_TYPE_SEQUENCE_ENROLLMENT,
            self::OBJECT_TYPE_SUBSCRIPTION,
            self::OBJECT_TYPE_ACCEPTANCE_TEST,
            self::OBJECT_TYPE_SOCIAL_BROADCAST,
            self::OBJECT_TYPE_DEAL_SPLIT,
            self::OBJECT_TYPE_DEAL_REGISTRATION,
            self::OBJECT_TYPE_GOAL_TARGET,
            self::OBJECT_TYPE_GOAL_TARGET_GROUP,
            self::OBJECT_TYPE_PORTAL_OBJECT_SYNC_MESSAGE,
            self::OBJECT_TYPE_FILE_MANAGER_FILE,
            self::OBJECT_TYPE_FILE_MANAGER_FOLDER,
            self::OBJECT_TYPE_SEQUENCE_STEP_ENROLLMENT,
            self::OBJECT_TYPE_APPROVAL,
            self::OBJECT_TYPE_APPROVAL_STEP,
            self::OBJECT_TYPE_CTA_VARIANT,
            self::OBJECT_TYPE_SALES_DOCUMENT,
            self::OBJECT_TYPE_DISCOUNT,
            self::OBJECT_TYPE_FEE,
            self::OBJECT_TYPE_TAX,
            self::OBJECT_TYPE_MARKETING_CALENDAR,
            self::OBJECT_TYPE_PERMISSIONS_TESTING,
            self::OBJECT_TYPE_PRIVACY_SCANNER_COOKIE,
            self::OBJECT_TYPE_DATA_SYNC_STATE,
            self::OBJECT_TYPE_WEB_INTERACTIVE,
            self::OBJECT_TYPE_PLAYBOOK,
            self::OBJECT_TYPE_FOLDER,
            self::OBJECT_TYPE_PLAYBOOK_QUESTION,
            self::OBJECT_TYPE_PLAYBOOK_SUBMISSION,
            self::OBJECT_TYPE_PLAYBOOK_SUBMISSION_ANSWER,
            self::OBJECT_TYPE_COMMERCE_PAYMENT,
            self::OBJECT_TYPE_GSC_PROPERTY,
            self::OBJECT_TYPE_SOX_PROTECTED_DUMMY_TYPE,
            self::OBJECT_TYPE_BLOG_LISTING_PAGE,
            self::OBJECT_TYPE_QUARANTINED_SUBMISSION,
            self::OBJECT_TYPE_PAYMENT_SCHEDULE,
            self::OBJECT_TYPE_PAYMENT_SCHEDULE_INSTALLMENT,
            self::OBJECT_TYPE_MARKETING_CAMPAIGN_UTM,
            self::OBJECT_TYPE_DISCOUNT_TEMPLATE,
            self::OBJECT_TYPE_DISCOUNT_CODE,
            self::OBJECT_TYPE_FEEDBACK_SURVEY,
            self::OBJECT_TYPE_CMS_URL,
            self::OBJECT_TYPE_SALES_TASK,
            self::OBJECT_TYPE_SALES_WORKLOAD,
            self::OBJECT_TYPE_USER,
            self::OBJECT_TYPE_POSTAL_MAIL,
            self::OBJECT_TYPE_SCHEMAS_BACKEND_TEST,
            self::OBJECT_TYPE_PAYMENT_LINK,
            self::OBJECT_TYPE_SUBMISSION_TAG,
            self::OBJECT_TYPE_CAMPAIGN_STEP,
            self::OBJECT_TYPE_SCHEDULING_PAGE,
            self::OBJECT_TYPE_SOX_PROTECTED_TEST_TYPE,
            self::OBJECT_TYPE_ORDER,
            self::OBJECT_TYPE_MARKETING_SMS,
            self::OBJECT_TYPE_PARTNER_ACCOUNT,
            self::OBJECT_TYPE_CAMPAIGN_TEMPLATE,
            self::OBJECT_TYPE_CAMPAIGN_TEMPLATE_STEP,
            self::OBJECT_TYPE_PLAYLIST,
            self::OBJECT_TYPE_CLIP,
            self::OBJECT_TYPE_CAMPAIGN_BUDGET_ITEM,
            self::OBJECT_TYPE_CAMPAIGN_SPEND_ITEM,
            self::OBJECT_TYPE_MIC,
            self::OBJECT_TYPE_CONTENT_AUDIT,
            self::OBJECT_TYPE_CONTENT_AUDIT_PAGE,
            self::OBJECT_TYPE_PLAYLIST_FOLDER,
            self::OBJECT_TYPE_LEAD,
            self::OBJECT_TYPE_ABANDONED_CART,
            self::OBJECT_TYPE_EXTERNAL_WEB_URL,
            self::OBJECT_TYPE_VIEW,
            self::OBJECT_TYPE_VIEW_BLOCK,
            self::OBJECT_TYPE_ROSTER,
            self::OBJECT_TYPE_CART,
            self::OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW_ACTION,
            self::OBJECT_TYPE_SOCIAL_PROFILE,
            self::OBJECT_TYPE_PARTNER_CLIENT,
            self::OBJECT_TYPE_ROSTER_MEMBER,
            self::OBJECT_TYPE_MARKETING_EVENT_ATTENDANCE,
            self::OBJECT_TYPE_ALL_PAGES,
            self::OBJECT_TYPE_AI_FORECAST,
            self::OBJECT_TYPE_CRM_PIPELINES_DUMMY_TYPE,
            self::OBJECT_TYPE_UNKNOWN,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('extra_context', $data ?? [], null);
        $this->setIfExists('object_type_id', $data ?? [], null);
        $this->setIfExists('error_type', $data ?? [], null);
        $this->setIfExists('known_column_number', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('source_data', $data ?? [], null);
        $this->setIfExists('object_type', $data ?? [], null);
        $this->setIfExists('invalid_value', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['error_type'] === null) {
            $invalidProperties[] = "'error_type' can't be null";
        }
        $allowedValues = $this->getErrorTypeAllowableValues();
        if (!is_null($this->container['error_type']) && !in_array($this->container['error_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'error_type', must be one of '%s'",
                $this->container['error_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['source_data'] === null) {
            $invalidProperties[] = "'source_data' can't be null";
        }
        $allowedValues = $this->getObjectTypeAllowableValues();
        if (!is_null($this->container['object_type']) && !in_array($this->container['object_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'object_type', must be one of '%s'",
                $this->container['object_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets created_at
     *
     * @return int
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param int $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets extra_context
     *
     * @return string|null
     */
    public function getExtraContext()
    {
        return $this->container['extra_context'];
    }

    /**
     * Sets extra_context
     *
     * @param string|null $extra_context extra_context
     *
     * @return self
     */
    public function setExtraContext($extra_context)
    {
        if (is_null($extra_context)) {
            throw new \InvalidArgumentException('non-nullable extra_context cannot be null');
        }
        $this->container['extra_context'] = $extra_context;

        return $this;
    }

    /**
     * Gets object_type_id
     *
     * @return string|null
     */
    public function getObjectTypeId()
    {
        return $this->container['object_type_id'];
    }

    /**
     * Sets object_type_id
     *
     * @param string|null $object_type_id object_type_id
     *
     * @return self
     */
    public function setObjectTypeId($object_type_id)
    {
        if (is_null($object_type_id)) {
            throw new \InvalidArgumentException('non-nullable object_type_id cannot be null');
        }
        $this->container['object_type_id'] = $object_type_id;

        return $this;
    }

    /**
     * Gets error_type
     *
     * @return string
     */
    public function getErrorType()
    {
        return $this->container['error_type'];
    }

    /**
     * Sets error_type
     *
     * @param string $error_type error_type
     *
     * @return self
     */
    public function setErrorType($error_type)
    {
        if (is_null($error_type)) {
            throw new \InvalidArgumentException('non-nullable error_type cannot be null');
        }
        $allowedValues = $this->getErrorTypeAllowableValues();
        if (!in_array($error_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'error_type', must be one of '%s'",
                    $error_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['error_type'] = $error_type;

        return $this;
    }

    /**
     * Gets known_column_number
     *
     * @return int|null
     */
    public function getKnownColumnNumber()
    {
        return $this->container['known_column_number'];
    }

    /**
     * Sets known_column_number
     *
     * @param int|null $known_column_number known_column_number
     *
     * @return self
     */
    public function setKnownColumnNumber($known_column_number)
    {
        if (is_null($known_column_number)) {
            throw new \InvalidArgumentException('non-nullable known_column_number cannot be null');
        }
        $this->container['known_column_number'] = $known_column_number;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets source_data
     *
     * @return \HubSpot\Client\Crm\Imports\Model\ImportRowCore
     */
    public function getSourceData()
    {
        return $this->container['source_data'];
    }

    /**
     * Sets source_data
     *
     * @param \HubSpot\Client\Crm\Imports\Model\ImportRowCore $source_data source_data
     *
     * @return self
     */
    public function setSourceData($source_data)
    {
        if (is_null($source_data)) {
            throw new \InvalidArgumentException('non-nullable source_data cannot be null');
        }
        $this->container['source_data'] = $source_data;

        return $this;
    }

    /**
     * Gets object_type
     *
     * @return string|null
     */
    public function getObjectType()
    {
        return $this->container['object_type'];
    }

    /**
     * Sets object_type
     *
     * @param string|null $object_type object_type
     *
     * @return self
     */
    public function setObjectType($object_type)
    {
        if (is_null($object_type)) {
            throw new \InvalidArgumentException('non-nullable object_type cannot be null');
        }
        $allowedValues = $this->getObjectTypeAllowableValues();
        if (!in_array($object_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'object_type', must be one of '%s'",
                    $object_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['object_type'] = $object_type;

        return $this;
    }

    /**
     * Gets invalid_value
     *
     * @return string|null
     */
    public function getInvalidValue()
    {
        return $this->container['invalid_value'];
    }

    /**
     * Sets invalid_value
     *
     * @param string|null $invalid_value invalid_value
     *
     * @return self
     */
    public function setInvalidValue($invalid_value)
    {
        if (is_null($invalid_value)) {
            throw new \InvalidArgumentException('non-nullable invalid_value cannot be null');
        }
        $this->container['invalid_value'] = $invalid_value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


