<?php

namespace App\Models;

use App\Extensions\Canvas\System\Http\Models\UserTiptapContent;
use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Support\Facades\Schema;

class UserOpenaiChatMessage extends Model
{
    use HasFactory;

    protected $table = 'user_openai_chat_messages';

    protected $fillable = [
        'user_openai_chat_id',
        'user_id',
        'input',
        'response',
        'output',
        'hash',
        'credits',
        'words',
        'images',
        'pdfName',
        'pdfPath',
        'outputImage',
        'realtime',
        'is_chatbot',
    ];

    public function chat()
    {
        return $this->belongsTo(UserOpenaiChat::class, 'user_openai_chat_id', 'id');
    }

    // tiptap edit result
    public function tiptapContent(): MorphOne
    {
        if (! class_exists(UserTiptapContent::class) || ! $this->tableExists('user_tiptap_contents')) {
            return $this->morphOne(self::class, 'user_openai_chat', 'user_id', 'id')->whereRaw('1 = 0');
        }

        return $this->morphOne(UserTiptapContent::class, 'save_contentable');
    }

    /**
     * Check if a table exists in the database
     */
    private function tableExists($tableName): bool
    {
        try {
            return Schema::hasTable($tableName);
        } catch (Exception $e) {
            return false;
        }
    }
}
